unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AHMSystemClass, AHMTScheduler, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Button1: TButton;
    AHMScheduler1: TAHMScheduler;
    Label2: TLabel;
    StatusBar1: TStatusBar;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    Label5: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure AHMScheduler1Schedules0Trigger(Sender: TObject;
      const ScheduleID: String; var Active: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
const MaxScheds = 10;
Var I : Integer;
begin
  For I:=1 to MaxScheds do
  begin
    if AHMScheduler1.Schedules.Count>MaxScheds-1 then // just reassigns new times in a second run of the schedules
       AHMScheduler1.Schedules[I-1].Triggertime:=TimeToStr(AHMAddToTime(Time,0,0,5*I))
    else with AHMScheduler1.Schedules.Add do
    begin
      Active:=True;
      // using new Function AHMAddToTime(CTime : TTime;Hours,Minutes,Seconds : Longint) : TTime;
      // this function allows you to add full integers. Eg. 90 seconds as compared to 1 minute and 30 seconds)
      TriggerTime:=TimeToStr(AHMAddToTime(Time,0,0,5*I));
      ScheduleID:=Inttostr(I);
      OnTrigger:=AHMScheduler1Schedules0Trigger;
    end;
  end;
  Button1.Enabled:=False;
end;

procedure TForm1.AHMScheduler1Schedules0Trigger(Sender: TObject;
  const ScheduleID: String; var Active: Boolean);
begin
  if (Sender is TAHMScheduledTime) then // should be the case if you do not call it direct
  Statusbar1.SimpleText:='Event No. '+ScheduleID+' triggered. Scheduled for '+TAHMScheduledTime(Sender).TriggerTime;
  Beep;
  if StrToInt(ScheduleID)=AHMScheduler1.Schedules.Count then Button1.Enabled:=True;
end;

end.
 